/*
Tento cel sbor je licencovan pod GNU GENERAL PUBLIC LICENSE version 3 https://www.gnu.org/licenses/gpl-3.0.html
Autor: Adam Struharansk
Neexistuj absoltne iadne zruky funnosti a pouitelnosti na iaden el,
a vetci autori sa zriekaj zodpovednosti za akkovek kody vyplvajce z jeho pouitia.

There are absolutely no warranties of functionality and/or usability for any purpose,
and all authors disclaim liability for any damages resulting from its use.
*/


#ifndef GRAPH_MAKER
#define GRAPH_MAKER

#include <iostream> 
#include <stdlib.h>     
#include <vector>
#include <algorithm>
#include <time.h>       /* time */
using namespace std;

//aby nevznikali cykly - kazda hrana moze ist iba z vrcholu s mensim cislom do vrcholu s vacsim

//vytvori pseudo-nahodny acyklycky graf s num_vertices vrcholmi, a num_edges hranami,
//nie nutne suvisly, nie nutne so spojenim pramena a ustia
std::vector<std::vector<pair<int, int>>> random_graph(int num_vertices, int num_edges, int max_capacity) {
	srand(time(NULL));
	std::vector<std::vector<pair<int, int>>> graph;
	for (int i = 0; i < num_vertices; i++) {
		graph.push_back(std::vector<pair<int, int>>());
	}
	int new_num_edges = 0;
	//doplnit - spojenie nahodnych vrcholov zaciatku s nejakymi, a nejakymi inymi s koncom
	while (new_num_edges < num_edges) {
		int a = rand() % num_vertices;
		int b = rand() % num_vertices;
		if (a != b) {//nerovnake, nevytvarat slucky
			int str = min(a, b);
			int end = max(a, b);
			bool additable = true;
			for (int i = 0; i < graph.at(str).size(); i++) {//nevytvarat nasobne hrany
				if (graph.at(str).at(i).first == end) {
					additable = false;
					break;
				}
			}
			if (additable) {
				graph.at(str).push_back(std::pair<int, int>(end, (rand() % max_capacity) + 1));
				new_num_edges++;
			}
		}
	}
	return graph;
}


#endif // !GRAPH_MAKER
